package cn.quantgroup.xyqb.controller.middleoffice.wx;

import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.ITenantService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.util.TenantUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 微信
 */
@Slf4j
@RestController
@RequestMapping("/middle_office/wx")
public class WxController {

    @Resource
    private IWechatService wechatService;

    @Autowired
    private ITenantService tenantService;

    @Autowired
    private IUserService userService;

    /**
     * @ yapi http://open.quantgroups.com/project/59/interface/api/693
     * @ yapi http://yapi.quantgroups.com/project/17/interface/api/30122
     * @param userId
     * @return
     */
    @GetMapping("/userId/{userId}")
    public JsonResult openId(@PathVariable Long userId, @RequestParam(required = false) Integer tenantId) {
        //默认羊小咩租户
        if (tenantId == null) {
            tenantId = TenantUtil.TENANT_DEFAULT;
        }
        WechatUserInfo wechatUserInfo = wechatService.queryByUserId(userId);
        if (wechatUserInfo == null) {
            return JsonResult.buildSuccessResult();
        }
        /* 校验租户ID */
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            wechatUserInfo = tenantService.getTenantCustomerInfo(wechatUserInfo, tenantId);
            if (wechatUserInfo == null) {
                return JsonResult.buildSuccessResult();
            }
        }
        return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
    }

    /**
     * @ yapi http://yapi.quantgroups.com/project/17/interface/api/30122
     * @param userId
     * @param appName
     * @param tenantId
     * @return
     */
    @GetMapping("/userId/{userId}/{appName}")
    public JsonResult openId(@PathVariable Long userId,@PathVariable String appName, @RequestParam(required = false) Integer tenantId) {
        WechatUserInfo wechatUserInfo = wechatService.queryByUserId(userId,appName);
        if (wechatUserInfo == null) {
            return JsonResult.buildSuccessResult();
        }
        /* 校验租户ID */
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            wechatUserInfo = tenantService.getTenantCustomerInfo(wechatUserInfo, tenantId);
            if (wechatUserInfo == null) {
                return JsonResult.buildSuccessResult();
            }
        }
        return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
    }

    /**
     * @yapi http://open.quantgroups.com/project/59/interface/api/693
     * @yapi http://yapi.quantgroups.com/project/17/interface/api/30122
     * @param phoneNo
     * @return
     */
    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult openId(@PathVariable String phoneNo, @RequestParam(required = false) Integer tenantId) {
        if (tenantId == null) {
            tenantId = TenantUtil.TENANT_DEFAULT;
        }
        WechatUserInfo wechatUserInfo = wechatService.findWechatUserInfoByPhoneNo(phoneNo);
        if (wechatUserInfo == null) {
            return JsonResult.buildSuccessResult();
        }
        /* 校验租户ID */
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            wechatUserInfo = tenantService.getTenantCustomerInfo(wechatUserInfo, tenantId);
            if (wechatUserInfo == null) {
                return JsonResult.buildSuccessResult();
            }
        }
        return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
    }

    @RequestMapping("/code/{key}/{extdata}")
    public void receiveCode(@PathVariable String key, @PathVariable String extdata) {
        //todo
    }

    @PatchMapping("/forbidden/{userId}")
    public JsonResult forbidden(@PathVariable Long userId, String reason) {
        int res = wechatService.forbiddenUserWeChat(userId);
        log.info("取消微信关联 userId:{},reason:{},结果:{}", userId, reason, res);
        return JsonResult.buildSuccessResultGeneric(res);
    }
}
