package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.entity.User;

import java.util.List;
import java.util.Map;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface IUserService {

  User findByPhoneWithCache(String phone);

  User findByUuidWithCache(String uuid);

  boolean exist(String phoneNo);

  boolean resetPassword(String phoneNo, String password);

  User findByPhoneInDb(String phone);

  User findByUuidInDb(String uuid);

  Map<Long, String> findPhoneByIdsInDb(List<Long> userIds);

  User saveUser(User user);

  User findById(Long userId);

  List<User> findByPhones(List<String> phones);

  List<User> findRegisterUserByTime(String beginTime,String endTime);

  /**
   * 禁用用户
   *
   * @param phoneNo 电话号码
   */
  int forbiddenUser(Boolean enable,String phoneNo);

}
