package cn.quantgroup.xyqb.service.register.impl;

import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.AbstractUserRegisterService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by liqing on 2017/12/4 0004.
 */
@Service("userRegisterService")
@Slf4j
public class UserRegisterServiceImpl extends AbstractUserRegisterService {

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User registerDefault(UserRegisterParam userRegisterParam) {
        return getDefaultUserRegisterHandler().handleRegister(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User registerExt(UserRegisterParam userRegisterParam) {
        return getExtUserRegisterHandler().handleRegister(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId, Long btRegisterChannelId) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerDefault(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(String phoneNo, String password, Long registerFrom) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).password(password)
                .generateRandomPwd(false).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerDefault(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean register(String phoneNo, String password, Long registerFrom, String ip, Long channelId, Long btRegisterChannelId, String dimension) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).password(password)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .dimension(dimension)
                .generateRandomPwd(false).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        User user = registerDefault(userRegisterParam);
        return user != null;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(String phoneNo, Long channelId, Long registerFrom, String appChannel, Long btRegisterChannelId, String dimension) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .dimension(dimension)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerDefault(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(Long registeredFrom, Long channelId, String phoneNo, String name, String idNo, String provinceCode, String province, String cityCode, String city, String districtCode, String district, String address, String contacts,Long btRegisterChannelId) {
        Address addressObj = new Address();
        addressObj.setProvinceCode(Long.valueOf(provinceCode));
        addressObj.setProvince(province);
        addressObj.setCityCode(Long.valueOf(cityCode));
        addressObj.setCity(city);
        addressObj.setDistrictCode(Long.valueOf(districtCode));
        addressObj.setDistrict(district);
        addressObj.setAddress(address);
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registeredFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId)
                .btRegisterChannelId(btRegisterChannelId)
                .address(addressObj).contacts(contacts)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerExt(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerDefault(userRegisterParam);
    }
}
