package cn.quantgroup.xyqb.config.motan;

import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by 11 on 2017/2/27.
 */
@Configuration
public class MotanConfig {

  @Bean
  public AnnotationBean motanAnnotationBean() {
    AnnotationBean motanAnnotationBean = new AnnotationBean();
    motanAnnotationBean.setPackage("cn.quantgroup.xyqb.controller.external.motan");
    return motanAnnotationBean;
  }

  @Bean(name = "userMotan")
  public ProtocolConfigBean protocolConfig1(
      @Value("${protocol.isDefault}") Boolean isDefault, @Value("${protocol.name}") String name,
      @Value("${protocol.contentLength}") int contentLength) {
    ProtocolConfigBean config = new ProtocolConfigBean();
    config.setDefault(isDefault);
    config.setName(name);
    config.setMaxContentLength(contentLength);
    config.setMaxServerConnection(1000);
    return config;
  }


  @Bean(name = "registryConfig")
  public RegistryConfigBean registryConfig(@Value("${registry.protocol}") String registryProtocol,
                                           @Value("${registry.address}") String registryAddress
  ) {
    RegistryConfigBean config = new RegistryConfigBean();
    config.setRegProtocol(registryProtocol);
    config.setAddress(registryAddress);
    return config;
  }

  @Bean
  public BasicServiceConfigBean baseServiceConfig(@Value("${motan.port}") int motanPort,
                                                  @Value("${motan.user.group}") String userGroup,
                                                  @Value("${motan.user.module}") String userModule,
                                                  @Value("${motan.application:xyqbUserMotan}") String applicationName) {
    BasicServiceConfigBean config = new BasicServiceConfigBean();
    config.setExport("userMotan:" + motanPort);
    config.setGroup(userGroup);
    config.setVersion("1.0");
    config.setAccessLog(true);
    config.setShareChannel(true);
    config.setModule(userModule);
    config.setApplication(applicationName);
    config.setRegistry("registryConfig");
    return config;
  }
}
