package cn.quantgroup.xyqb.aspect.fplock;

import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by Miraculous on 15/11/10.
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FPRestriction {
  // 持续时间
  int duration() default 1;

  // 持续时间单位
  TimeUnit type() default TimeUnit.MINUTES;

  // 限制值, -1表示不限制
  int limit() default -1;

  // 使用可覆盖
  boolean override() default true;
}
