package cn.quantgroup.xyqb.security;

import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.security.authentication.AuthenticationManager;

/**
 * Created by Administrator on 2021/7/1 0001.
 */
@Slf4j
public class AuthenticationFactory {
    public static AuthenticationManager getManager(String name){
        AuthenticationManager manager = null;
        try {
            manager = ApplicationContextHolder.getBean(name.concat("AuthenticationManager"), AuthenticationManager.class);
            if (manager == null) {
                throw new IllegalArgumentException("No such authentication manager "+name);
            }
        } catch (BeansException e) {
            throw new IllegalArgumentException("No such authentication manager "+name);
        }
        return manager;
    }
}
