package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;

@Data
public class UserBean {
    private Long userId;
    private List<Wechat> wechatList;
    private String phoneNo;

    private Long registeredFrom;

    private String uuid;

    private Boolean enable;
    private Integer tenantId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createdAt;

    @Builder
    @Getter
    public static class Wechat {
        private String openId;
        private String appId;
        private String unionId;
    }


    public static UserBean from(User user, List<WechatUserInfo> wechatUserInfoList) {
        UserBean userBean = new UserBean();
        userBean.setUserId(user.getId());
        userBean.setPhoneNo(user.getPhoneNo());
        userBean.setRegisteredFrom(user.getRegisteredFrom());
        userBean.setUuid(user.getUuid());
        userBean.setEnable(user.getEnable());
        userBean.setTenantId(user.getTenantId());
        userBean.setCreatedAt(user.getCreatedAt());
        if (CollectionUtils.isNotEmpty(wechatUserInfoList)) {
            List<Wechat> wcList = Lists.newArrayList();
            wechatUserInfoList.stream().forEach(wechatUserInfo->{
                Wechat build = Wechat.builder()
                        .openId(wechatUserInfo.getOpenId())
                        .unionId(wechatUserInfo.getUnionId())
                        .appId(wechatUserInfo.getAppId()).build();

                wcList.add(build);
            });
            userBean.setWechatList(wcList);
        }
        return userBean;
    }

    public static List<UserBean> from(List<User> userList, List<WechatUserInfo> wechatUserInfoList) {
        List<UserBean> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(userList)) {
            userList.forEach(user -> {
                UserBean userBean = new UserBean();
                userBean.setUserId(user.getId());
                userBean.setPhoneNo(user.getPhoneNo());
                userBean.setRegisteredFrom(user.getRegisteredFrom());
                userBean.setUuid(user.getUuid());
                userBean.setEnable(user.getEnable());
                userBean.setTenantId(user.getTenantId());
                userBean.setCreatedAt(user.getCreatedAt());
                if (CollectionUtils.isNotEmpty(wechatUserInfoList)) {
                    Optional<WechatUserInfo> optionalWechatUserInfo = wechatUserInfoList.stream().filter(i -> i.getUserId() != null && i.getUserId().equals(user.getId())).findFirst();

                    if (optionalWechatUserInfo.isPresent()) {
                        WechatUserInfo wechatUserInfo = optionalWechatUserInfo.get();
                        userBean.setWechatList(Collections.singletonList(Wechat.builder()
                                .openId(wechatUserInfo.getOpenId())
                                .unionId(wechatUserInfo.getUnionId())
                                .appId(wechatUserInfo.getAppId()).build()));
                    }
                }
                result.add(userBean);
            });
        }
        return result;
    }
}
