package cn.quantgroup.xyqb.repository;


import cn.quantgroup.xyqb.entity.WechatUserInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by 11 on 2017/1/18.
 */
public interface IWeChatUserRepository extends JpaRepository<WechatUserInfo, Long> {
  WechatUserInfo findByOpenId(String openId);

  WechatUserInfo findByPhoneNo(String phoneNo);

  WechatUserInfo findByUserId(Long userId);

  long countByOpenId(String openId);

  @Transactional
  @Modifying
  int removeByUserId(Long userId);
}
