package cn.quantgroup.xyqb.exception;


import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum BizExceptionEnum {
    // 登录相关10开通
    UN_EXIT_TENANT_ID("1001","租户id不存在"),
    UN_EXIT_REGISTERED_FROM("1001","注册来源不存在"),
    UN_AUTHORIZED("1002","请先登录"),
    UN_EXIT_USER("1003","用户不存在"),
    ERROR_PASSWORD("1004","用户名或者密码错误"),
    EXPIRE_SMS_CODE("1005","验证码失效，请重新获取"),
    ERROR_SMS_CODE("1006","短信验证码错误"),
    ERROR_OR_ENABLE_ERROR("1007","账号异常，请联系平台客服。"),
    ERROR_DIRECT_LOGIN("1008","极验登录验证失败"),
    ERROR_WECHAT_APP_ID("1009","请先配置微信appId"),
    ERROR_WECHAT_LOGIN("1010","微信登录失败"),
    ERROR_INTERNAL_LOGIN("1011","公开接口不能调用内部登录方式"),
    ERROR_LOGIN_PARAM("1012","登录参数异常，请按接口文档对接"),
    UN_EXIT_STMS_TOKEN("1013","stms的token不存在"),
    UN_VALID_STMS_TOKEN("1014","无效的stms的token"),
    UN_PERMISSION_STMS("1015","没有内部接口访问权限"),
    EXPIRE_WECHAT_TOKEN("1016","微信接口token过期，请执行定时任务"),
    ERROR_MATCHING_WECHAT_APP_ID("1017","微信appName和appId不匹配"),
    ERROR_WECHAT_BIND_USERID("1018","微信未和用户绑定,登录失败"),




    // 验证码相关 20 开头
    FAIL_GENERATE_IMAGE("2001","生成图片失败"),
    FAIL_VERIFY_CODE("2002","图形验证码验证错误"),
    UN_EXIT_VERIFY_TYPE("2003","不存在的验证码方式"),
    UN_EXIT_VERIFY_CODE("2004","验证模式下验证码参数不能为空"),
    EX_GET_VERIFY_CODE("2005","获取验证码失败"),
    UN_EXIT_GEETEST_LOG("2006","极验记录不存在"),
    PHONE_MAX_PER_DAY("2007","今天已获取20次短信验证码，请使用语音验证码或明天再试"),
    DEVICE_MAX_PER_DAY("2008","您设备已经达到获取今天验证码上限"),
    IP_MAX_PER_DAY("2009","您当前ip已经达到获取今天短信验证码上限"),
    DUPLICATE_MIN("2010","1分钟内不能重复获取验证码"),
    PHONE_VOICE_MAX_PER_DAY("2011","今天已获取5次语音验证码，请使用短信验证码或明天再试"),
    ERROR_USAGE("2022","参数校验失败,用户登录语音验证码usage不正确"),
    ERROR_SEND_SMS("2023","验证码发送失败"),
    //通用记录
    ERROR_PARAM("4000","参数错误"),
    INVALID_SMS_CODE("4001","验证码失效，请重新获取");

    private final String businessCode;
    private final String msg;
}
