package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.controller.req.v2.BehaviorReq;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.model.BehaviorCodeBean;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.UUID;

/**
 * 极验模式
 */
@Service
public class GeetestBehaviorStrategy implements BehaviorStrategy {
    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    @Override
    public Integer getType() {
        return 1;
    }

    @Override
    public boolean validate(ValidateBehavior validateBehavior) {
        return false;
    }


    @Override
    public BehaviorCodeBean generate(BehaviorReq behaviorReq) {
        BehaviorCodeBean behaviorCodeBean = new BehaviorCodeBean();
        String key = StringUtils.isNotBlank(behaviorReq.getPhone()) ? behaviorReq.getPhone().trim() : UUID.randomUUID().toString();
        // key指纹
        Map<String, String> imgMap = geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5(key), behaviorReq.getIp(), ClientType.valueByCode(behaviorReq.getClientType()));

        if (imgMap.containsKey("success") && "1".equals(imgMap.get("success"))) {
            behaviorCodeBean.setType(1);
            behaviorCodeBean.setGeetestCode(BehaviorCodeBean.GeetestCode.builder().gt(imgMap.get("gt"))
                    .challenge(imgMap.get("challenge"))
                    .reChallenge(imgMap.get("reChallenge")).
                    build());

        } else {
            behaviorCodeBean.setType(2);
        }
        return behaviorCodeBean;
    }
}
