package cn.quantgroup.xyqb.model;

import java.util.Optional;

/**
 * 验证码验证类型
 *
 * @author renwc
 * @date 2018-02-02
 */
public enum ClientType {
    APP("native"), H5("h5"), WEB("web");

    ClientType(String alias) {
        this.alias = alias;
    }

    private String alias;

    public String getAlias() {
        return this.alias;
    }

    public static ClientType valueByName(String name) {
        name = Optional.ofNullable(name).orElse("").toLowerCase();
        switch (name) {
            case "h5":
                return H5;
            case "web":
                return WEB;
            default:
                return APP;
        }
    }

    public static ClientType valueByCode(Integer code) {
        switch (code) {
            case 0:
                return H5;
            case 1:
                return WEB;
            default:
                return APP;
        }
    }

}
