package cn.quantgroup.xyqb.filter;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.service.v2.BehaviorContext;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

public class BehaviorInterceptor implements HandlerInterceptor {

    private final BehaviorContext behaviorContext;

    public BehaviorInterceptor(BehaviorContext behaviorContext) {
        this.behaviorContext = behaviorContext;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String type = request.getHeader(Constants.X_BEHAVIOR_TYPE);
        if (StringUtils.isEmpty(type) || !StringUtils.isNumeric(type)) {
            return true;
        }
        switch (Integer.parseInt(type)) {
            case 1:
                //走极验逻辑
                return false;
            case 2:
                //走量化派图形验证逻辑
                String id = request.getHeader(Constants.X_BEHAVIOR_ID);
                String imageValue = request.getHeader(Constants.X_BEHAVIOR_IMAGEVALUE);
                if (StringUtils.isEmpty(id) || StringUtils.isEmpty(imageValue)) {
                    throw new BizException(BizExceptionEnum.UN_EXIT_VERIFY_CODE);
                }

                ValidateBehavior validateBehavior = new ValidateBehavior();
                validateBehavior.setType(2);
                Map<String, String> data = new HashMap<>();
                data.put("id", id);
                data.put("imageValue", imageValue);
                validateBehavior.setData(data);
                behaviorContext.validate(validateBehavior);
            default:
                return true;
        }

    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        XyqbSessionContextHolder.releaseSession();
    }
}
