package cn.quantgroup.xyqb.config.sentry;

import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import io.sentry.Sentry;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * {@link HandlerExceptionResolver} implementation that will record any exception that a
 * Spring {@link org.springframework.web.servlet.mvc.Controller} throws to Sentry. It then
 * returns null, which will let the other (default or custom) exception resolvers handle
 * the actual error.
 */
public class CustomSentryExceptionResolver implements HandlerExceptionResolver, Ordered {
    @Override
    public ModelAndView resolveException(HttpServletRequest request,
                                         HttpServletResponse response,
                                         Object handler,
                                         Exception ex) {
        // TODO: 2020/2/4 临时测试，后期修改成通用。
        if (ex instanceof VerificationCodeErrorException) {
            return null;
        }
        if (ex instanceof BadCredentialsException) {
            return null;
        }

        Sentry.capture(ex);

        // null = run other HandlerExceptionResolvers to actually handle the exception
        return null;
    }

    @Override
    public int getOrder() {
        // ensure this resolver runs first so that all exceptions are reported
        return Integer.MIN_VALUE;
    }
}