package cn.quantgroup.xyqb.aspect.captcha;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.captcha.geetest.IGeetestCaptchaService;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.octo.captcha.service.CaptchaServiceException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.UUID;

/**
 * @author xufei on 2018/1/30.
 */
@Aspect
@Component
@Slf4j
public class CaptchaNewValidateAdvisor {
    private static final String SUPER_CAPTCHA_ID = UUID.nameUUIDFromBytes("__QG_APPCLIENT_AGENT__".getBytes(Charset.forName("UTF-8"))).toString();
    private static final String SUPER_CAPTCHA = "__SUPERQG__";

    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    @Resource
    @Qualifier("customCaptchaService")
    private AbstractManageableImageCaptchaService imageCaptchaService;

    /**
     * 自动化测试忽略验证码
     */
    @Value("${xyqb.auth.captcha.autotest.enable:false}")
    private boolean autoTestCaptchaEnabled;

    /**
     * 图形验证码切面
     */
    @Pointcut("@annotation(cn.quantgroup.xyqb.aspect.captcha.CaptchaNewValidator)")
    private void needCaptchaValidate() {

    }

    /**
     * 在受图形验证码保护的接口方法执行前, 执行图形验证码校验
     *
     * @param pjp pjp
     * @return
     * @throws Throwable
     */
    @Around("needCaptchaValidate()")
    private Object doCaptchaValidate(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

        if (Constants.GT_CAPTCHA_UNUSER.equals(request.getParameter(Constants.GEETEST_CAPTCHA_STATUS))) {
            //极验不可用，用QG
            if (isQuantgroupCaptchaValidateSuccess(request)) {
                return pjp.proceed();
            } else {
                return JsonResult.buildErrorStateResult("图形验证码有误", "");
            }
        } else {
            String challenge = request.getParameter(Constants.FN_GEETEST_CHALLENGE);
            String validate = request.getParameter(Constants.FN_GEETEST_VALIDATE);
            String seccode = request.getParameter(Constants.FN_GEETEST_SECCODE);
            String phoneNo = request.getParameter("phoneNo");
            String clientType = request.getParameter("clientType");
            geetestCaptchaService.captchaValidate(clientType, PasswordUtil.MD5(phoneNo), IPUtil.getRemoteIP(request), challenge, validate, seccode);
            log.info("使用极验二次验证,phoneNo:{}", phoneNo);
        }
        return pjp.proceed();
    }

    private Boolean isQuantgroupCaptchaValidateSuccess(HttpServletRequest request) throws Throwable {
        String registerFrom = Optional.ofNullable(request.getParameter("registerFrom")).orElse("");
        String captchaId = Optional.ofNullable(request.getParameter("captchaId")).orElse("");
        String captchaValue = request.getParameter("captchaValue");
        if (isSkipCaptchaValidate(captchaId, captchaValue)) {
            log.info("使用超级图形验证码校验, registerFrom={}, clientIp={}", registerFrom, IPUtil.getRemoteIP(request));
            return Boolean.TRUE;
        }

        Boolean validCaptcha = false;
        if (StringUtils.isNotBlank(captchaValue)) {
            // 忽略用户输入的大小写
            String captcha = StringUtils.lowerCase(captchaValue);
            // 验证码校验
            try {
                validCaptcha = imageCaptchaService.validateResponseForID(Constants.IMAGE_CAPTCHA_KEY + captchaId, captcha);
            } catch (CaptchaServiceException ex) {
                log.error("验证码校验异常, {}, {}", ex.getMessage(), ex);
            }
        }
        return validCaptcha;
    }

    private boolean isSkipCaptchaValidate(String captchaId, Object captchaValue) {
        // 如果启用了超级验证码功能, 检查超级验证码, 超级验证码区分大小写
        return autoTestCaptchaEnabled || org.apache.commons.lang3.StringUtils.equals(SUPER_CAPTCHA_ID, String.valueOf(captchaId))
                && org.apache.commons.lang3.StringUtils.equals(SUPER_CAPTCHA, String.valueOf(captchaValue));
    }

}
