package cn.quantgroup.xyqb.controller.external.captcha;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.aspect.captcha.CaptchaNewValidator;
import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.captcha.geetest.IGeetestCaptchaService;
import cn.quantgroup.xyqb.service.captcha.qg.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author xufei on 2018/1/30.
 */
@Slf4j
@RestController
@RequestMapping("/api")
public class NewCaptchaController {
    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    @Resource
    private IQuantgroupCaptchaService quantgroupCaptchaService;


    @LogHttpCaller
    @RequestMapping(value = "/newCaptcha")
    public JsonResult getCaptcha(HttpServletRequest request, String phoneNo) {
        if (!ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult("手机号格式错误", null);
        }

        log.info("[newCaptcha]获取验证码,phoneNo:{}", phoneNo);
        String geetestCaptcha = geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5(phoneNo),
                IPUtil.getRemoteIP(request), request.getParameter("clientType"));
        if (Constants.GT_CAPTCHA_UNUSER.equals(geetestCaptcha)) {
            try {
                return JsonResult.buildSuccessResult("", quantgroupCaptchaService.fetchCaptcha(request.getLocale()));
            } catch (Exception e) {
                log.error("获取验证码失败e:{}", e);
                return JsonResult.buildErrorStateResult("", "fail");
            }
        } else {
            log.info("[newCaptcha]极验可用,phoneNo:{}", phoneNo);
            return JsonResult.buildSuccessResult("", geetestCaptcha);
        }

    }

    @CaptchaNewValidator
    @RequestMapping("/new_verification_image_code")
    public JsonResult verificationImageCode() {
        return JsonResult.buildSuccessResult("", null);
    }


}
