package cn.quantgroup.xyqb.repository;


import cn.quantgroup.xyqb.entity.WechatUserInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static org.springframework.transaction.annotation.Propagation.MANDATORY;

/**
 * Created by 11 on 2017/1/18.
 * modify by djh 20200527 http://confluence.quantgroup.cn/pages/viewpage.action?pageId=30657427
 */
public interface IWeChatUserRepository extends JpaRepository<WechatUserInfo, Long> {
    WechatUserInfo findByOpenIdAndAppName(String openId, String appName);

    WechatUserInfo findByPhoneNoAndAppName(String phoneNo, String appName);

    WechatUserInfo findByEncryptedPhoneNoAndAppName(String phoneNo, String appName);

    WechatUserInfo findByUserIdAndAppName(Long userId, String appName);

    WechatUserInfo findFirstByUserIdAndAppNameOrderByCreatedAtDesc(Long userId, String appName);

    long countByOpenIdAndAppName(String openId, String appName);

    /**
     * 解除关联关系 -- 当前用户的已关联微信
     * 注：应用服务的JDBC数据源连接，无delete权限
     *
     * @param userId
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where user_id=?1 and app_name=?2", nativeQuery = true)
    int dissociateByUserIdAndAppName(Long userId, String appName);

    /**
     * 解除商城用户与小程序和公众号关联关系
     *
     * @param userId 用户id
     * @return 结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where user_id=?1 and app_name in ('xyqb', 'wuxi')", nativeQuery = true)
    int forbiddenXyqbAndWuxiUserByUserId(Long userId);

    /**
     * 关联用户
     *
     * @param userId  - 用户标识
     * @param phoneNo
     * @param openId  - 微信标识
     * @return 记录更新行数
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=?1,phone_no=?2 where open_id=?3 and user_id is null and app_name=?4", nativeQuery = true)
    int relateUser(Long userId, String phoneNo, String openId, String appName);

    /**
     * 解除关联关系 -- 包括：1、当前微信旧的关联用户；2、当前用户旧的关联微信
     * 强制事务
     *
     * @param openId - 微信标识
     * @param userId - 用户标识
     * @return 记录更新行数
     */
    @Transactional(propagation = MANDATORY, rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where (open_id=?1 or user_id=?2) and app_name=?3", nativeQuery = true)
    int dissociateUser(String openId, Long userId, String appName);


    /**
     * 更新unionId
     * @param userId
     * @param appName
     * @param unionId
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set union_id=?3 where user_id=?1 and app_name=?2", nativeQuery = true)
    int updateUserUnionId(Long userId, String appName, String unionId);

    @Transactional
    void deleteByUserId(Long userId);

    /**
     * 通过userId查询相关绑定微信记录
     */
    List<WechatUserInfo> findByUserId(Long userId);

    /**
     * 通过unionId查询相关绑定微信记录
     */
    List<WechatUserInfo> findByUnionId(String unionId);

    List<WechatUserInfo> findByUnionIdIn(List<String> unionIds);
}
