package cn.quantgroup.xyqb.controller.internal.login;

import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserRet;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IUserBtRegisterService;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 查询已登录信息
 * Created by Miraculous on 2016/12/30.
 */
@RestController
@RequestMapping("/auth")
@Slf4j
public class AuthInfoController implements IBaseController {


  @LogHttpCaller
  @RequestMapping("/info/login")
  public JsonResult loginInfo(HttpServletRequest request) {
    SessionStruct sessionStruct = getCurrentSessionFromRedis();
    if(null != sessionStruct) {
      log.info("从用户中心获取到了用户登录信息:phone:[{}]", sessionStruct.getValues().getUser().getPhoneNo());
      LoginInfo loginInfo = new LoginInfo();
      loginInfo.setUser(new UserRet(sessionStruct.getValues().getUser()));
      loginInfo.setToken(sessionStruct.getSid());
      LoginInfo.LoginContext context = new LoginInfo.LoginContext();
      context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
      context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
      context.setAppChannel(sessionStruct.getValues().getLoginProperties().getAppChannel());
      context.setBtMerchantId(sessionStruct.getValues().getLoginProperties().getBtMerchantId());
      //有ThreadLocal不释放的问题，不可再使用原来方式了
      loginInfo.setLoginContext(context);
      log.info("[/auth/info/login] SessionStruct数据：{}, LoginInfo数据：{}", JSONObject.toJSONString(sessionStruct), JSONObject.toJSONString(loginInfo));
      return JsonResult.buildSuccessResult("", loginInfo);
    }
    log.info("[/auth/info/login] 未查到用户登录信息, request-Header:{}", JSON.toJSONString(getRequestHeaderMap(request)));
    return JsonResult.buildErrorStateResult("用户未登录",null);
  }

}
