package cn.quantgroup.xyqb.util;

import cn.quantgroup.xyqb.Constants;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Decoder;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * AES编码器工具
 * 使用AES加密解密 AES-128-ECB加密
 * @version 1.0
 */
@Slf4j
public class AESUtil {

    /**
     * KEY算法
     */
    private static final String KEY_ALGORITHM = "AES";
    /**
     * 加密算法
     * "/算法/模式/补码方式"
     */
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    /**
     * 编码格式
     */
    private static final String DATA_ENCODING = "utf-8";

    /**
     * 数据解密，返回字符串
     * @param data 待解密的数据
     * @param key  解密使用的KEY
     * @return 解密之后的数据
     */
    public static String decryptAfterBase64Decode(String data, String key) {
        try {
            byte[] bytes = decryptAfterBase64DecodeToByte(data, key);
            if (bytes != null && bytes.length > 0){
                return new String(bytes, DATA_ENCODING);
            }
        } catch (Exception e) {
            log.error("AES-解密出错:data:{},key:{}", data, key, e);
        }
        return null;
    }

    /**
     * 数据解密，返回字节数据
     * @param data
     * @param key
     * @return
     */
    private static byte[] decryptAfterBase64DecodeToByte(String data, String key) {
        try {
            if (key == null || "".equals(key.trim().length())) {
                return null;
            }
            byte[] raw = key.getBytes(DATA_ENCODING);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);
            byte[] encrypted1 = new Base64().decode(data);
            byte[] original = cipher.doFinal(encrypted1);
            return original;
        } catch (Exception e) {
            log.error("AES-解密出错:data:{},key:{}", data, key, e);
        }
        return null;
    }

    /**
     * 数据加密
     *
     * @param data 待加密的数据
     * @param key  加密使用的KEY
     * @return 加密之后的数据
     */
    public static String encryptAndBase64Encode(String data, String key) {
        try {
            return encryptAndBase64Encode(data.getBytes(DATA_ENCODING), key);
        } catch (Exception e) {
            log.error("AES-加密出错:data:{},key:{}", data, key, e);
            return null;
        }
    }

    /**
     * 对字节数组加密
     * @param data
     * @param key
     * @return
     */
    private static String encryptAndBase64Encode(byte[] data, String key) {
        try {
            if (StringUtils.isBlank(key)) {
                log.error("AES-加密出错:AES Key为空：data:{},key:{}", data, key);
                return null;
            }
            return doEncryptAndBase64Encode(data, key);
        } catch (Exception ex) {
            log.error("AES-加密出错:data:{},key:{}", data, key);
            return null;
        }
    }

    /**
     * 执行加密和base64编码
     * @param data
     * @param key
     * @return
     * @throws Exception
     */
    private static String doEncryptAndBase64Encode(byte[] data, String key) throws Exception {
        byte[] raw = key.getBytes(DATA_ENCODING);
        SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
        byte[] encrypted = cipher.doFinal(data);
        return new Base64().encodeToString(encrypted);
    }

    public static void main(String[] args){
        System.out.println(encryptAndBase64Encode("45949139", Constants.AES_KEY));
        System.out.println(encryptAndBase64Encode("18611428880", Constants.AES_KEY));
        System.out.println(encryptAndBase64Encode("15810672369", Constants.AES_KEY));
    }

}
