package cn.quantgroup.xyqb.service.api.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.model.BlacklistMatchResult;
import cn.quantgroup.xyqb.service.api.IUserApiService;
import cn.quantgroup.xyqb.service.model.IModelService;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by FrankChow on 15/12/16.
 */
@Service
public class UserApiServiceImpl implements IUserApiService {

    @Autowired
    private IModelService modelService;

    @Autowired
    private IUserService userService;



    @Override
    public boolean userImportCheck(String phoneNo) {
        User user=userService.findByPhoneWithCache(phoneNo);

        if (user!=null){
            return false;
        }

        BlacklistMatchResult blacklistMatchResult = modelService.getBlacklistMatchResult(phoneNo);
        if (blacklistMatchResult == null) {
            return true;
        }
        return !blacklistMatchResult.getFlag();
    }
}
