package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.entity.UserHashPhoneNoIdNoMapping;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.repository.IUserHashMappingRepository;
import cn.quantgroup.xyqb.repository.IUserHashPhoneNoIdNoMappingRepository;
import cn.quantgroup.xyqb.util.encrypt.Md5Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.persistence.PersistenceException;

@Component
@Slf4j
public class PhoneHashEventListener implements ApplicationListener<RegisterEvent> {

    @Autowired
    private IUserHashMappingRepository userHashMappingRepository;
    @Resource
    private IUserHashPhoneNoIdNoMappingRepository userHashPhoneNoIdNoMappingRepository;

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        log.info("onApplicationEvent cn.quantgroup.xyqb.event.PhoneHashEventListener start");
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        String phoneNo = userRegisterParam.getPhoneNo();
        Long userId = userRegisterParam.getUser().getId();

        String idNo = userRegisterParam.getIdNo();

        UserHashPhoneNoIdNoMapping userHashPhoneNoIdNoMapping = userHashPhoneNoIdNoMappingRepository.findByUserId(userId);
        if (userHashPhoneNoIdNoMapping == null) {
            userHashPhoneNoIdNoMapping = new UserHashPhoneNoIdNoMapping(userId);
        }
        StringBuilder phoneNoIdNoMd5 = new StringBuilder(phoneNo);
        if (StringUtils.isNotEmpty(idNo)) {
            phoneNoIdNoMd5.append(idNo);
        }
        userHashPhoneNoIdNoMapping.setPhoneNoIdNoMd5(Md5Util.build(phoneNoIdNoMd5.toString().toUpperCase()));
        try {
            userHashPhoneNoIdNoMappingRepository.saveAndFlush(userHashPhoneNoIdNoMapping);
        } catch (PersistenceException e) {
            log.error("保存userHashPhoneNoIdNoMapping重复, 无需再保存, userId:{}", userId);
        }

        UserHashMapping userHashMapping = userHashMappingRepository.findByUserId(userId);
        if (userHashMapping != null && userHashMapping.getIdNoMd5() != null) {
            //已存在的用户, 并且已存在身份证号
            return;
        }
        if (userHashMapping == null) {
            //创建一个新的
            userHashMapping = new UserHashMapping(userId);
        }
        //无论如何都更新手机号
        String phoneNoMd5 = Md5Util.build(phoneNo);
        userHashMapping.setPhoneNoMd5(phoneNoMd5);


        //如果有身份证号. 更新一下
        if (StringUtils.isNotEmpty(idNo)) {
            idNo = idNo.toUpperCase();
            userHashMapping.setIdNoMd5(Md5Util.build(idNo));
        }

        try {
            userHashMappingRepository.saveAndFlush(userHashMapping);
        } catch (PersistenceException e) {
        	// 可能与UserDetailUpdateEvent并发写入问题，暂不优化
            log.warn("保存userHashMapping重复, 无需再保存, userId:{}", userId);
        }

    }
}
