package cn.quantgroup.xyqb.service.user.vo;

import cn.quantgroup.motan.retbean.XUserDetail;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.sql.Timestamp;

@Data
@NoArgsConstructor
public class UserDetailVO {
  private Long id;

  private Long userId;

  private String phoneNo;

  private String name;

  private String idNo;

  private IdType idType;

  private Boolean isAuthenticated = false;

  private Gender gender;

  private String email;

  private String qq;

  private Boolean enable;

  private Long createdAt;

  private Long updatedAt;


  public static UserDetailVO fromUserDetail(UserDetail userDetail) {
    UserDetailVO userDetailVO = new UserDetailVO();
    userDetailVO.id = userDetail.getId();
    userDetailVO.userId = userDetail.getUserId();
    userDetailVO.phoneNo = userDetail.getPhoneNo();
    userDetailVO.name = userDetail.getName();
    userDetailVO.idNo = userDetail.getIdNo();
    userDetailVO.idType = userDetail.getIdType();
    userDetailVO.isAuthenticated = userDetail.getIsAuthenticated();
    userDetailVO.gender = userDetail.getGender();
    userDetailVO.email = userDetail.getEmail();
    userDetailVO.qq = userDetail.getQq();
    if (userDetail.getCreatedAt() != null) {
      userDetailVO.createdAt = userDetail.getCreatedAt().getTime();
    }
    if (userDetail.getUpdatedAt() != null) {
      userDetailVO.updatedAt = userDetail.getUpdatedAt().getTime();
    }
    return userDetailVO;
  }

  public XUserDetail toXUserDetail() {
    XUserDetail xUserDetail = new XUserDetail();
    xUserDetail.setId(this.getId());
    xUserDetail.setUserId(this.getUserId());
    xUserDetail.setPhoneNo(this.getPhoneNo());
    xUserDetail.setName(this.getName());
    xUserDetail.setIdNo(this.getIdNo());
    if (this.getIdType() != null) {
      xUserDetail.setIdType(cn.quantgroup.user.enums.IdType.valueOf(this.getIdType().name()));
    }
    if (this.getGender() != null) {
      xUserDetail.setGender(cn.quantgroup.user.enums.Gender.valueOf(this.getGender().name()));
    }
    xUserDetail.setEmail(this.getEmail());
    xUserDetail.setQq(this.getQq());
    xUserDetail.setId(this.getId());
    if (this.getCreatedAt() != null) {
      xUserDetail.setCreatedAt(new Timestamp(this.getCreatedAt()));
    }
    if (this.getUpdatedAt() != null) {
      xUserDetail.setUpdatedAt(new Timestamp(this.getUpdatedAt()));
    }
    xUserDetail.setIsAuthenticated(this.getIsAuthenticated());
    xUserDetail.setEnable(this.getEnable());
    return xUserDetail;
  }

}
