package cn.quantgroup.xyqb.session;

import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Miraculous on 2016/12/29.
 */
public class XyqbSessionContextHolder {

    private static final ThreadLocal<SessionStruct> threadSession = new ThreadLocal<>();
    public static volatile RedisTemplate<String, String> redisTemplate = null;

    public static SessionStruct getSession() {
        if (threadSession.get() != null) {
            return threadSession.get();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String token = request.getHeader("x-auth-token");
        if (token == null || token.length() != 36) {
            return null;
        }
        redisTemplate.opsForValue().get(Constants.Session)
    }

}
