package cn.quantgroup.xyqb.controller;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface IBaseController {

    default User getCurrentUser() {
        return null;
    }

    default SessionStruct getSessionStruct() {
        String token = StringUtils.defaultString(getRequest().getHeader("x-auth-token"), "");
        ApplicationContextHolder.getBean("stringRedisTemplate");
    }

    default HttpSession getSession() {
        HttpSession session = null;
        try {
            HttpServletRequest request;
            request.getRequestedSessionId()
            session = getRequest().getSession();
        } catch (Exception e) {
            e.getStackTrace();
        }
        return session;
    }

    default Long getChannelId() {
        return getNumber("channelId");
    }

    default Long getCreatedFrom() {
        return getNumber("createdFrom");
    }

    default Long getNumber(String name) {
        HttpSession session = getSession();
        try {
            Long number = Long.valueOf(session.getAttribute(name).toString());
            return number;
        } catch (Exception e) {
            e.getStackTrace();
        }
        return 0L;
    }

    default void setChannelId(Long channelId) {
        HttpSession session = getSession();
        if (session != null) {
            session.setAttribute("channleId", channelId);
        }
    }

    default String getAppChannel() {
        HttpSession session = getSession();
        Object appChannel = session.getAttribute("appChannel");
        if(appChannel == null){
            return null;
        }
        return appChannel.toString();
    }


    default HttpServletRequest getRequest() {
        ServletRequestAttributes attrs = (ServletRequestAttributes) RequestContextHolder
                .getRequestAttributes().setAttribute();
        return attrs.getRequest();
    }

    default String getIp() {
        HttpServletRequest request = getRequest();

        String ip = request.getHeader("x-real-ip");
        if (StringUtils.isEmpty(ip)) {
            ip = request.getRemoteAddr();
        }

        //过滤反向代理的ip
        String[] stemps = ip.split(",");
        if (stemps != null && stemps.length >= 1) {
            //得到第一个IP，即客户端真实IP
            ip = stemps[0];
        }

        ip = ip.trim();
        if (ip.length() > 23) {
            ip = ip.substring(0, 23);
        }

        return ip;
    }
}
