package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.entity.Contact;

import java.util.List;

/**
 * Created by Miraculous on 2017/1/3.
 */
public interface IContactService {
    /**
     * @param userId - 用户主键
     * @param trim   - 是否清除非法错误记录，true-清除，false-不清除
     * @return
     */
    List<Contact> findByUserId(Long userId, boolean trim);

    Contact findById(Long id);

    /**
     * 批量保存用户联系人
     * 如果已存在联系人，则覆盖更新
     *
     * @param userId   - 用户主键
     * @param contacts - 联系人列表
     * @return
     */
    List<Contact> save(Long userId, List<Contact> contacts);

    Contact save(Contact contact);

    Contact saveContact(String name, String phoneNo, Relation relation, Contact contact);
}
