package cn.quantgroup.xyqb.util;

//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

import java.io.Serializable;
import org.slf4j.helpers.MessageFormatter;

public class StringUtils extends org.springframework.util.StringUtils {
    public static final char DELIMITED_ID_SEP = '$';
    public static final char DELIMITED_ID_WCHAR = '*';

    public StringUtils() {
    }

    public static String defaultIfNull(String object, String defaultValue) {
        return object == null ? defaultValue : object;
    }

    public static <T extends Serializable> String toDelimitedString(T... ids) {
        return toDelimitedString('$', ids);
    }

    public static <T extends Serializable> String toDelimitedString(char separator, T... ids) {
        int len = ids.length;
        StringBuilder builder = new StringBuilder();
        Serializable[] var4 = ids;
        int var5 = ids.length;

        for(int var6 = 0; var6 < var5; ++var6) {
            Object id = var4[var6];
            if (id == null) {
                builder.append('*');
            } else {
                builder.append(id.toString());
            }

            --len;
            if (len == 0) {
                break;
            }

            builder.append(separator);
        }

        return builder.toString();
    }

    public static String format(String msg, Object... args) {
        return MessageFormatter.arrayFormat(msg, args).getMessage();
    }
}

