package cn.quantgroup.xyqb.controller.middleoffice.userdetail;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.validator.ChineseName;
import cn.quantgroup.xyqb.validator.IdCard;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.sql.Timestamp;

/**
 * 用户实名信息
 */
@RestController
@RequestMapping("/middle_office/user_detail")
public class UserDetailController {

    @Resource
    private IUserDetailService userDetailService;

    @Resource
    private IUserService userService;

    @Resource
    private IIdCardService idCardService;

    /**
     * 修改用户实名信息
     *
     * @param userId
     * @param name
     * @param idNo
     * @return
     */
    @PutMapping("/{userId}")
    public JsonResult update(@PathVariable Long userId,
                             @ChineseName String name,
                             @IdCard String idNo) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        if (userDetail == null) {
            return save(userId, name, idNo);
        }
        //更新
        userDetail.setName(name);
        userDetail.setIdNo(idNo);
        userDetail.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
        userDetail = userDetailService.saveUserDetail(userDetail);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 保存用户实名信息
     *
     * @param userId
     * @param name
     * @param idNo
     * @return
     */
    @PostMapping("/{userId}")
    public JsonResult save(@PathVariable Long userId,
                           @ChineseName String name,
                           @IdCard String idNo) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        if (userDetail != null) {
            return JsonResult.buildSuccessResultGeneric(userDetail);
        }
        User user = userService.findById(userId);
        IdCardInfo idCardInfo = idCardService.getIdCardInfo(idNo);
        Timestamp now = new Timestamp(System.currentTimeMillis());

        userDetail = new UserDetail();
        userDetail.setUserId(userId);
        userDetail.setName(name);
        userDetail.setPhoneNo(user.getPhoneNo());
        userDetail.setIdNo(idNo);
        userDetail.setIdType(IdType.ID_CARD);
        userDetail.setGender(idCardInfo.getGender());
        userDetail.setCreatedAt(now);
        userDetail.setUpdatedAt(now);
        userDetail = userDetailService.saveUserDetail(userDetail);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 根据用户 ID，查询实名信息
     *
     * @param userId
     * @return
     */
    @GetMapping("/userId/{userId}")
    public JsonResult query(@PathVariable Long userId) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 根据手机号，查询实名信息
     *
     * @param phoneNo
     * @return
     */
    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult query(@PathVariable String phoneNo) {
        UserDetail userDetail = userDetailService.findByPhoneNo(phoneNo);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

}
