package cn.quantgroup.xyqb.controller.middleoffice.common;

import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

@Component
public class VerifyStrategyFactory{

    private static final Map<VerifyTypeEnum, IVerifyStrategy> strategiesMap = new HashMap<>();

    @PostConstruct
    public void init(){
        //cache
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        Map<String, IVerifyStrategy> beansOfType = context.getBeansOfType(IVerifyStrategy.class);
        beansOfType.values().forEach(strategy -> strategiesMap.put(strategy.strategyName(), strategy));
    }

    public static IVerifyStrategy get(VerifyTypeEnum verifyTypeEnum){
        return strategiesMap.get(verifyTypeEnum);
    }

}
