package cn.quantgroup.xyqb.risk.uereventcollecting;

import cn.qg.ec.kinesis.EnvironmentConfig;
import cn.qg.ec.kinesis.KinesisProducerClient;
import cn.quantgroup.tech.util.TechEnvironment;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/21 16:15
 * @description：client获取
 * @modified By：
 * @version:
 */
public class KinesisProducerClientFactory {
    private KinesisProducerClientFactory() {
    }

    private static KinesisProducerClient client;

    public static KinesisProducerClient getClient() {
        if (null == client) {
            synchronized (KinesisProducerClient.class) {
                if (null == client) {
                    client = new KinesisProducerClient(getConfig());
                }
            }
        }
        return client;
    }

    private static EnvironmentConfig getConfig() {
        if (!TechEnvironment.isPro()) {
            return EnvironmentConfig.DEV;
        }
        return EnvironmentConfig.PROD;
    }
}
