package cn.quantgroup.xyqb.exception;


import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum BizExceptionEnum {
    // 登录相关10开通
    UN_EXIT_TENANT_ID("1001","租户id不存在"),
    UN_EXIT_REGISTERED_FROM("1001","租户id不存在"),
    UN_AUTHORIZED("1002","请先登录"),
    UN_EXIT_USER("1003","用户不存在"),
    ERROR_PASSWORD("1004","用户名或者密码错误"),
    EXPIRE_SMS_CODE("1005","验证码失效，请重新获取"),
    ERROR_SMS_CODE("1006","短信验证码错误"),
    ERROR_OR_ENABLE_ERROR("1007","账号异常，请联系平台客服。"),
    ERROR_DIRECT_LOGIN("1008","极验登录验证失败"),
    ERROR_WECHAT_APP_ID("1009","请先配置微信appId"),
    ERROR_WECHAT_LOGIN("1010","微信登录失败"),
    ERROR_INTERNAL_LOGIN("1011","公开接口不能调用内部登录方式"),
    ERROR_LOGIN_PARAM("1012","登录参数异常，请按接口文档对接"),



    // 验证码相关 20 开头
    FAIL_GENERATE_IMAGE("2001","生成图片失败"),
    FAIL_VERIFY_CODE("2002","图形验证码错误"),
    UN_EXIT_VERIFY_TYPE("2003","不存在的验证码方式"),
    UN_EXIT_VERIFY_CODE("2004","验证模式下验证码参数不能为空"),
    EX_GET_VERIFY_CODE("2005","获取验证码失败"),
    UN_EXIT_GEETEST_LOG("2006","极验记录不存在");


    private final String businessCode;
    private final String msg;
}
