
---用户表
ALTER TABLE `xyqb_user`.`user`
ADD COLUMN `password_type` TINYINT(3) NULL DEFAULT 0 COMMENT '0：是用户中心之前的加密方式，1:是消费地图迁移的数据加密方式' AFTER `cipher_password`,
ADD COLUMN `tenant_id` INT  NULL DEFAULT 560761 COMMENT '租户id' AFTER `password_type`;

----新增用户资料表
CREATE TABLE `xyqb_user`.`user_info` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `user_id` BIGINT(20) NOT NULL COMMENT '用户表id',
  `phone_no` VARCHAR(20) NULL COMMENT '手机号码',
  `gender` TINYINT(3) NULL COMMENT '性别',
  `email` VARCHAR(45) NULL COMMENT '邮箱',
  `qq` VARCHAR(20) NULL COMMENT '腾讯qq',
  `name` VARCHAR(45) NULL COMMENT '名称',
  `nick_name` VARCHAR(45) NULL COMMENT '昵称',
  `photo` VARCHAR(255) NULL COMMENT '头像地址',
  `birthday` DATE NULL COMMENT '生日',
  `province_id` INT NULL COMMENT '地址省份id',
  `city_id` INT NULL COMMENT '地址市id',
  `address` VARCHAR(255) NULL COMMENT '详细地址',
  `tenant_id` INT NOT NULL DEFAULT 560761  COMMENT '租户id',
  `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP  ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE `udx_user_id` (`user_id` ASC),
  INDEX `idx_user_phone` (`phone_no` ASC)
  );

---微信用户登录表,app_id可能需要跟app_name进行洗
ALTER TABLE `xyqb_user`.`wechat_userinfo`
ADD COLUMN `session_key` VARCHAR(255) NULL COMMENT '第三方sessionkey' AFTER `encrypted_phone_no`,
ADD COLUMN `tenant_id` INT  NULL DEFAULT 560761 COMMENT '租户id' AFTER `session_key`,
ADD COLUMN `registered_from` BIGINT(20) NULL COMMENT '来源（之前字段）' AFTER `tenant_id`,
ADD COLUMN `app_id` VARCHAR(32) NULL COMMENT '微信应用id' AFTER `registered_from`;



---微信配置表
--CREATE TABLE `xyqb_user`.`wechat_config` (
--  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
--  `app_id` VARCHAR(32) NOT NULL COMMENT '微信app_id\n',
--  `secret` VARCHAR(64) NOT NULL COMMENT '微信appsecret',
--  `state` TINYINT(3) NOT NULL COMMENT '状态',
--  `tenant_id` INT NOT NULL COMMENT '租户id',
--  `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
--  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP  ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
--  PRIMARY KEY (`id`));

--用户标记表（用来标记同一租户下用户归属）
CREATE TABLE `xyqb_user`.`user_tag` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `user_id` BIGINT(20) NOT NULL COMMENT '用户表id',
  `registered_from` BIGINT(20) NULL COMMENT '来源（之前字段）',
  `tenant_id` INT NOT NULL DEFAULT 560761 COMMENT '租户id',
  `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP  ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  UNIQUE INDEX `udx_user_id` (`user_id` ASC, `registered_from` ASC, `tenant_id` ASC);
  PRIMARY KEY (`id`));



--  上线需要清洗数据(SET sql_safe_updates=off;)
UPDATE  `xyqb_user`.`wechat_userinfo` SET app_id ='wx0a7c0bce0c3ac523' WHERE app_name='xyqb';
UPDATE  `xyqb_user`.`wechat_userinfo` SET app_id ='wxb3e6270e1b1e0bc7' WHERE app_name='wuxi';
UPDATE  `xyqb_user`.`wechat_userinfo` SET app_id ='wxbd0bc68b270a1dab' WHERE app_name='qhyd-line';
UPDATE  `xyqb_user`.`wechat_userinfo` SET app_id ='S7hLi03Uwui21ydfpDtDFaGLaEZWVAXe' WHERE app_name='baidu-mini';
UPDATE  `xyqb_user`.`wechat_userinfo` SET app_id ='2021003126632272' WHERE app_name='alipay-mini';







