package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import cn.quantgroup.xyqb.util.ValidationUtil;
import cn.quantgroup.xyqb.validator.IdCard;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.Date;

/**
 * Date: 2019/11/4
 * Time: 上午11:29
 *
 * @author: yangrui
 */
@Data
public class Step1Req implements Serializable {

    private static final long serialVersionUID = 3072182423041383540L;
    /**
     * 注册人真实姓名
     */
    @ApiModelProperty("注册人真实姓名")
    @NotBlank(message = "注册人真实姓名不能为空")
    @Length(max = 50, message = "注册人真实姓名最长50字符")
    private String name;

    /**
     * 注册人身份证件号
     */
    @ApiModelProperty("注册人身份证件号")
    @NotBlank(message = "注册人身份证件号不能为空")
    @IdCard
    private String idCard;

    /**
     * 当前手机号码
     */
    @ApiModelProperty("当前手机号码")
    @NotBlank(message = "当前手机号码不能为空")
    @Pattern(regexp = ValidationUtil.phoneRegExp, message = "当前手机号码格式错误")
    private String prevPhoneNo;

    /**
     * 新手机号码
     */
    @ApiModelProperty("新手机号码")
    @NotBlank(message = "新手机号码不能为空")
    @Pattern(regexp = ValidationUtil.phoneRegExp, message = "新手机号码格式错误")
    private String curPhoneNo;

    /**
     * 新手机号码短信验证码
     */
    @ApiModelProperty("新手机号码短信验证码")
    @NotBlank(message = "新手机号码短信验证码不能为空")
    private String smsCode;

    public static ModifyPhoneNo adapt(Step1Req step1Req) {
        ModifyPhoneNo modifyPhoneNo = new ModifyPhoneNo();
        BeanUtils.copyProperties(step1Req, modifyPhoneNo);
        Date date = new Date();
        modifyPhoneNo.setCreatedAt(date);
        modifyPhoneNo.setUpdatedAt(date);
        return modifyPhoneNo ;
    }
}
