package cn.quantgroup.xyqb.config;

import cn.quantgroup.security.AESEncryption;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 统一加解密配置
 *
 * @author killer
 * @date 2022年01月04日
 * @see <a href="http://confluence.quantgroup.cn/pages/viewpage.action?pageId=61679207">confluence</a>
 **/
@Configuration
public class SecurityConfig {

    @Value("${keystone.security.key}")
    private String key;

    @Value("${keystone.security.iv}")
    private String iv;

    @Bean
    public AESEncryption encryption() {
        return new AESEncryption(key, iv, true);
    }
}
