package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.util.HashUtil;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Data
@Entity
@Table(name = "user_hash_mapping")
@NoArgsConstructor
public class UserHashMapping extends BaseEntity implements Serializable {
    private static final long serialVersionUID = -1L;

    public UserHashMapping(Long userId) {
        this.userId = userId;
    }

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no_md5")
    private String phoneNoMd5;

    @Column(name = "phone_no_md5_short")
    private Long phoneNoMd5Short;


    public void setPhoneNoMd5(String phoneNoMd5) {
        this.phoneNoMd5 = phoneNoMd5;
        this.phoneNoMd5Short = HashUtil.crc32(phoneNoMd5);
    }

}