package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.financial.entity.User;
import cn.quantgroup.xyqb.financial.repository.IFinancialUserRepository;
import cn.quantgroup.xyqb.service.user.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

/**
 * Created by Miraculous on 15/7/5.
 */
@Service
@Slf4j
public class FinancialUserServiceImpl implements IFinancialUserService, IBaseController {

    @Autowired
    private RedisTemplate<String, String> stringRedisTemplate;

    @Autowired
    private IFinancialUserRepository financialUserRepository;


    @Override
    @CacheEvict(value = "usercache", key = "'xyqbuser' + #user.phoneNo", cacheManager = "cacheManager")
    public User saveUser(User user) {
        return financialUserRepository.saveAndFlush(user);
    }
}
