package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created by Miraculous on 15/7/4.
 */
public interface IUserRepository extends JpaRepository<User, Long>, JpaSpecificationExecutor<User> {

  User findByPhoneNo(String phoneNo);

  User findByUuid(String uuid);

  List<User> findByIdIn(List<Long> ids);

  User findById(Long id);

  @Query(value ="select * from user where created_at  between  STR_TO_DATE(?1,'%Y-%m-%d %H:%i:%s') and STR_TO_DATE(?2,'%Y-%m-%d %H:%i:%s') ", nativeQuery = true)
  List<User> findRegisterUserByTime(String beginTime,String endTime);

}
