package cn.quantgroup.xyqb.controller.middleoffice.sms;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.middleoffice.common.image.ImageDTO;
import cn.quantgroup.xyqb.controller.middleoffice.common.image.ImageVerifyStrategyFactory;
import cn.quantgroup.xyqb.controller.middleoffice.common.image.ImageVerifyTypeEnum;
import cn.quantgroup.xyqb.model.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 短信
 */
@Api(tags = "middle_office 短信 API")
@RestController("middleSmsController")
@RequestMapping("/middle_office/sms")
public class SmsController {

    @Resource
    private cn.quantgroup.xyqb.controller.external.sms.SmsController smsController;


    @ApiOperation(value = "获取短信验证码", httpMethod = "GET", notes="获取短信验证码")
    @GetMapping
    public JsonResult sms(SmsDTO sms,
                          ImageVerifyTypeEnum verifyType,
                          ImageDTO imageDTO) {
        boolean verify = ImageVerifyStrategyFactory.get(verifyType).verify(imageDTO);
        if (!verify) {
            return JsonResult.buildErrorStateResult("验证码错误", null);
        }
        //todo service
        String randomCode = smsController.getRandomCode(Constants.SMS_CODE_LEN_4);
        return smsController.sendVerificationCode2New(
                sms.getPhoneNo(), randomCode,
                sms.getDeviceId(), false,
                sms.getAppName(), sms.getSmsMerchant());
    }

    @ApiOperation(value = "重置密码获取短信验证码", httpMethod = "GET", notes="重置密码获取短信验证码")
    @PostMapping("/resetpwd")
    public JsonResult resetpwd(SmsDTO sms,
                               ImageVerifyTypeEnum verifyType,
                               ImageDTO imageDTO) {
        boolean verify = ImageVerifyStrategyFactory.get(verifyType).verify(imageDTO);
        if (!verify) {
            return JsonResult.buildErrorStateResult("验证码错误", null);
        }
        //todo 与 sms 不同的是，smsMerchant 不同，代表不同的模板。需要优化。。。
        String randomCode = smsController.getRandomCode(Constants.SMS_CODE_LEN_4);
        return smsController.sendVerificationCode2New(
                sms.getPhoneNo(), randomCode,
                sms.getDeviceId(), false,
                sms.getAppName(), sms.getSmsMerchant());
    }


}
