package cn.quantgroup.user.enums;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.Tuple;
import lombok.Getter;

/**
 * 用户状态枚举
 * <br>此枚举顺序不能更改,使用到了ordinal</>
 *
 * @author killer
 * @date 2021年12月17日
 **/
@Getter
public enum UserStatusEnum {

    /** 0 冻结 */
    FREEZE,
    /** 1 正常启用 */
    NORMAL,
    /** 2 销户 */
    DELETE;

    /**
     * 校验用户当前是否可用
     *
     * @param user user
     * @return 是否可用
     */
    public static Tuple<Boolean, JsonResult<?>> isDisable(User user) {
        switch (user.getEnable()) {
            case 0: {
                return Tuple.of(Boolean.TRUE, JsonResult.buildErrorStateResult("用户账户已冻结", null));
            }
            case 2: {
                return Tuple.of(Boolean.TRUE, JsonResult.buildErrorStateResult("用户账户已销户", null));
            }
            default:
                return Tuple.of(Boolean.FALSE, null);

        }
    }

    /**
     * 兼容历史接口入参为boolean值
     *
     * @param status 入参 true:启动;false:冻结
     * @return UserStatus
     */
    public static int converter(boolean status) {
        if (status) {
            return NORMAL.ordinal();
        }
        return FREEZE.ordinal();
    }

}
