package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by Miraculous on 15/7/4.
 */
public interface IUserRepository extends JpaRepository<User, Long>, JpaSpecificationExecutor<User> {

  User findByPhoneNo(String phoneNo);

  User findByUuid(String uuid);

  List<User> findByIdIn(List<Long> ids);

  User findById(Long id);

  @Query(value ="select * from user where created_at>=?1 and created_at<?2 ", nativeQuery = true)
  List<User> findRegisterUserByTime(String beginTime,String endTime);

  @Transactional
  @Modifying
  @Query(value = "update user set enable=?1 where phone_no=?2", nativeQuery = true)
  int forbiddenUser(Boolean enable, String phoneNo);

}
