package cn.quantgroup.xyqb.config.event;

import cn.quantgroup.tool.monitor.metric.api.ExecutorUtils;
import com.rabbitmq.client.impl.VariableLinkedBlockingQueue;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.scheduling.support.TaskUtils;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Slf4j
@Configuration
public class EventConfig {

    @Bean
    public ApplicationEventMulticaster applicationEventMulticaster(Executor taskExecutor) {
        SimpleApplicationEventMulticaster simpleApplicationEventMulticaster = new SimpleApplicationEventMulticaster();
        simpleApplicationEventMulticaster.setTaskExecutor(taskExecutor);
        simpleApplicationEventMulticaster.setErrorHandler(TaskUtils.LOG_AND_PROPAGATE_ERROR_HANDLER);
        return simpleApplicationEventMulticaster;
    }


    @Bean
    public Executor taskExecutor() {
        return ExecutorUtils.newExecutor(10, 50, 60, TimeUnit.SECONDS, new VariableLinkedBlockingQueue(1024), "Spring-UserLogin-Event");
    }

    public static class RejectedHandler implements RejectedExecutionHandler {

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            log.error("rejected : {}", r);
        }
    }

}
