package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.ProductLoginEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * Li Jianhua
 */
@Repository
public interface IProductLoginRepository extends JpaRepository<ProductLoginEntity, Long> {


    ProductLoginEntity findFirstByInstitutionIdAndProductIdAndPhoneNo(String institutionId, String productId, String phoneNo);
    ProductLoginEntity findFirstByInstitutionIdAndProductIdAndEncryptedPhoneNo(String institutionId, String productId, String phoneNo);

    ProductLoginEntity findFirstByPhoneNo(String phoneNo);

    ProductLoginEntity findByInstitutionIdAndProductIdAndExtensionAccountId(String institutionId, String productId, Long userId);
    List<ProductLoginEntity> findByInstitutionIdAndProductIdAndExtensionAccountIdIn(String institutionId, String productId, List<Long> userIds);

    List<ProductLoginEntity> findAllByExtensionAccountId(Long userId);
    List<ProductLoginEntity> findAllByExtensionAccountIdIn(List<Long> userId);

    /**
     * @author -REYLI
     * @createTime 2021-11-17
     * @description 根据条件获取租户下用户列表
     * @param institutionId
     * @param productId
     * @return Arraylist
     */
    List<ProductLoginEntity> findProductLoginsByInstitutionIdAndProductId(String institutionId, String productId);

    ProductLoginEntity findFirstByInstitutionIdAndProductIdAndCustomerId(String institutionId, String productId, long customerId);
}