package cn.quantgroup.xyqb.service.captcha.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.GeetestLib;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

/**
 * @author xufei on 2018/1/30.
 */
@Service
@Slf4j
public class GeetestCaptchaServiceImpl implements IGeetestCaptchaService {

    @Resource
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Value("${gt.server.status.exist.time}")
    private long gtServerStatusExistTime;

    @Value("${geetest.captcha.id}")
    private String captchaId;

    @Value("${geetest.private.key}")
    private String privateKey;

    @Value("${geetest.new.fail.back}")
    private boolean newFailback;

    @Value("${geetest.api.url}")
    private String apiUrl;
    private GeetestLib gtSdk;

    @Override
    public Map<String, String> fetchGeetestCaptcha(String markId, String remoteIp, ClientType clientType) {
        GeetestLib gtSdk = new GeetestLib(captchaId, privateKey, newFailback, apiUrl);
        HashMap<String, String> param = getParam(markId, remoteIp, clientType);
        log.info("请求极验参数:{}", param);
        Map<String, String> gtMap=getGeetestSdk().getResponseStr(param);
        log.info("请求极验返回:{}", gtMap);
        return gtMap;
    }

    @Override
    public boolean validGeetestCaptcha(String markId, String remoteIp, ClientType clientType, String challenge, String validate, String seccode) {
        HashMap<String, String> param = getParam(markId, remoteIp, clientType);
        log.info("二次验证参数:{},challenge:{},validate:{},seccode;{}", param,challenge,validate,seccode);
        int gtResult = getGeetestSdk().enhencedValidateRequest(challenge, validate, seccode, param);
        log.info("二次验证返回结果;{},版本信息:{}",gtResult);

        return Constants.GT_CAPTCHA_VALIDATE_SUCCESS==gtResult;
    }

    private GeetestLib getGeetestSdk() {
        return gtSdk =new GeetestLib(captchaId, privateKey, newFailback, apiUrl);
    }

    private HashMap<String, String> getParam(String markId, String remoteIp, ClientType clientType) {
        HashMap<String, String> param = new HashMap<>();
        param.put("user_id", markId);
        if (Objects.isNull(clientType)) {
            param.put("client_type", ClientType.APP.getAlias());
        }else{
            param.put("client_type", clientType.getAlias());
        }
        param.put("ip_address", remoteIp);
        return param;
    }
}
