package cn.quantgroup.xyqb.service.wechat;

import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.model.webchat.AccessTokenResponse;

/**
 * Created by Miraculous on 2017/1/19.
 */
public interface IWechatService {
    AccessTokenResponse getToken(String code);

    WechatUserInfo getWechatUserInfoFromWechatServer(String token, String openId);

    WechatUserInfo findWechatUserInfoFromDb(String openId);

    WechatUserInfo findWechatUserInfoByPhoneNo(String phoneNo);

    WechatUserInfo saveWechatUserInfo(WechatUserInfo userInfo);

    /**
     * 关联用户和微信
     *
     * @param userId  - 用户标识
     * @param phoneNo
     * @param openId  - 微信标识
     * @return
     */
    int relateUser(Long userId, String phoneNo, String openId);

    /**
     * 按userId查微信信息
     * 此接口实现处不应加缓存，否则解绑时（在关联用户的事务中）不好清除
     *
     * @param userId - 用户标识
     * @return
     */
    WechatUserInfo queryByUserId(Long userId);

    int forbiddenUserWeChat(Long userId);
}
