package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.ProductLoginEntity;
import cn.quantgroup.xyqb.repository.IProductLoginRepository;
import cn.quantgroup.xyqb.service.user.IProductLoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by 11 on 2016/12/29.
 */
@Slf4j
@Service
public class ProductLoginServiceImpl implements IProductLoginService {
    @Autowired
    private IProductLoginRepository productLoginRepository;

    @Override
    public ProductLoginEntity findSlaveByPloginInfo(String institutionId, String productId, Long userId) {
        ProductLoginEntity productLogin = productLoginRepository.findByInstitutionIdAndProductIdAndExtensionAccountId(institutionId, productId, userId);
        return productLogin;
    }

    @Override
    public List<ProductLoginEntity> findSlaveByProductLoginInfoList(String institutionId, String productId, List<Long> userIds) {
        return productLoginRepository.findByInstitutionIdAndProductIdAndExtensionAccountIdIn(institutionId, productId, userIds);
    }

    @Override
    public List<ProductLoginEntity> findSlaveByUserId(Long userId) {
        List<ProductLoginEntity> productLoginEntityList = productLoginRepository.findAllByExtensionAccountId(userId);
        return productLoginEntityList;
    }

    @Override
    public List<ProductLoginEntity> findSlaveByUserIds(List<Long> userIds) {
        return productLoginRepository.findAllByExtensionAccountIdIn(userIds);
    }

    @Override
    public List<ProductLoginEntity> findProductLoginsByInstitutionIdAndProductId(String institutionId, String productId) {
        return productLoginRepository.findProductLoginsByInstitutionIdAndProductId(institutionId, productId);
    }

    @Override
    public ProductLoginEntity findSlaveByCustomerInfo(long customerId, String institutionId, String productId) {
        return productLoginRepository.findFirstByInstitutionIdAndProductIdAndCustomerId(institutionId, productId, customerId);
    }

    @Override
    public ProductLoginEntity findTenantAndPhoneNo(String institutionId, String productId, String phoneNo) {
        ProductLoginEntity productLogin = productLoginRepository.findFirstByInstitutionIdAndProductIdAndEncryptedPhoneNo(institutionId, productId, phoneNo);
        if (productLogin == null) {
            productLogin = productLoginRepository.findFirstByInstitutionIdAndProductIdAndPhoneNo(institutionId, productId, phoneNo);
        }
        return productLogin;
    }
}
