package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.OauthClientDetailsEntity;
import cn.quantgroup.xyqb.entity.ProductLoginEntity;
import cn.quantgroup.xyqb.repository.IOauthClientDetailsRepository;
import cn.quantgroup.xyqb.service.user.IOauthClientDetailsService;
import java.util.ArrayList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by 11 on 2016/12/29.
 */
@Slf4j
@Service
public class OauthClientDetailsServiceImpl implements IOauthClientDetailsService {
    @Autowired
    private IOauthClientDetailsRepository oauthClientDetailsRepository;


    @Override
    public OauthClientDetailsEntity findFirstByClientId(Integer clientId) {
        OauthClientDetailsEntity oauthClientDetailsEntity = oauthClientDetailsRepository.findFirstByClientId(clientId);
        return oauthClientDetailsEntity;
    }

    @Override
    public List<Integer> findTenantList(List<ProductLoginEntity> productLoginEntityList) {
        List<Integer> tenantList = new ArrayList<>();
        for (ProductLoginEntity ple : productLoginEntityList) {
            OauthClientDetailsEntity oauthClientDetails = oauthClientDetailsRepository.findFirstByInstitutionIdAndProductId(ple.getInstitutionId(), ple.getProductId());
            if (null != oauthClientDetails) {
                tenantList.add(oauthClientDetails.getClientId());
            }
        }
        return tenantList;
    }



}
