package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.aspect.accessable.IpValidator;
import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.MqUtils;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

import static cn.quantgroup.xyqb.constant.UserConstant.USER_ERROR_OR_PASSWORD_ERROR;

/**
 * 第三方用户免密登录
 *
 * @author mengfan.feng
 * @time 2015-10-27 11:41
 */
@RestController
@RequestMapping("/app")
public class AppController implements IBaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppController.class);
    @Autowired
    private ISessionService sessionService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IMerchantService merchantService;
    @Autowired
    private IUserRegisterService userRegisterService;

    /**
     * 第三方用户免密登录
     * 发现新手机号，自动执行注册
     *
     * @param phoneNo             - 手机号
     * @param idNo                - 用户身份证号
     * @param name                - 用户姓名
     * @param key                 - Merchant表name属性
     * @param btRegisterChannelId - 白条注册渠道id
     * @param registerFrom        - 注册渠道
     * @param channelId           -
     * @param appChannel          -
     * @param request
     * @return Token和phoneNo
     */
    @LogHttpCaller
    @IpValidator
    @RequestMapping("/login")
    public JsonResult login(
            String phoneNo,
            String idNo, String name, String key,
            @RequestParam(required = false) Long btRegisterChannelId,
            @RequestParam(required = false, defaultValue = "1") Long registerFrom,
            @RequestParam(required = false, defaultValue = "1") Long channelId,
            @RequestParam(required = false, defaultValue = "") String appChannel,
            HttpServletRequest request) {
        if (!ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
        }
        // Todo -- 截止2017-12-08 13:44:00只有52次调用记录，来自222（白条），最近一次：2017-11-11 12:15:53
        LOGGER.info("第三方用户登录 [AppController] login --> loginFrom:{},channelId：{},btRegisterChannelId:{} requestIp:{},idNo:{},name:{}", registerFrom, channelId, btRegisterChannelId, IPUtil.getRemoteIP(request), idNo, name);
        User user = userService.findByPhoneInDb(phoneNo);
        if (user == null) {
            user = userRegisterService.register(registerFrom, phoneNo, idNo, name, channelId, btRegisterChannelId);
        }
        if (user == null) {
            return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
        }
        if (!user.getEnable()) {
            return JsonResult.buildErrorStateResult("登录失败", null);
        }
        Merchant merchant = merchantService.findMerchantByName(key);
        if (merchant == null) {
            return JsonResult.buildErrorStateResult("无效的商户", null);
        }
        LoginProperties loginProperties = new LoginProperties();
        loginProperties.setMerchantName(merchant.getName());
        loginProperties.setChannelId(channelId);
        loginProperties.setCreatedFrom(registerFrom);
        loginProperties.setAppChannel(appChannel);
        SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);
        AuthBean bean = new AuthBean();
        bean.setToken(sessionStruct.getSid());
        bean.setPhoneNo(phoneNo);
        LOGGER.info("第三方用户登录成功 [AppController] login --> loginFrom:{}, phoneNo:{},appChannel:{}", registerFrom, phoneNo, appChannel);
        return new JsonResult(bean);
    }

    /**
     * 第三方用户免密登录
     * 发现新手机号，自动执行注册
     *
     * @param phoneNo             - 手机号
     * @param idNo                - 用户身份证号
     * @param name                - 用户姓名
     * @param key                 - Merchant表name属性
     * @param btRegisterChannelId - 白条注册渠道id
     * @param registerFrom        - 注册渠道
     * @param channelId           -
     * @param appChannel          -
     * @param request
     * @return 用户信息
     */
    @LogHttpCaller
    @IpValidator
    @RequestMapping("/login_super")
    public JsonResult loginSuper(
            String phoneNo,
            String idNo, String name, String key,
            @RequestParam(required = false) Long btRegisterChannelId,
            @RequestParam(required = false, defaultValue = "1") Long registerFrom,
            @RequestParam(required = false, defaultValue = "1") Long channelId,
            @RequestParam(required = false, defaultValue = "") String appChannel,
            HttpServletRequest request) {
        if (!ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
        }
        LOGGER.info("第三方用户登录 [AppController] loginSuper --> loginFrom:{},phoneNo:{},appChannel:{},channelId：{},btRegisterChannelId:{} requestIp:{},idNo:{},name:{}", registerFrom, phoneNo, appChannel, channelId, btRegisterChannelId, IPUtil.getRemoteIP(request), idNo, name);
        User user = userService.findByPhoneInDb(phoneNo);
        if (user == null) {
            user = userRegisterService.register(registerFrom, phoneNo, idNo, name, channelId, btRegisterChannelId);
        }
        if (user == null) {
            return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
        }
        if (!user.getEnable()) {
            return JsonResult.buildErrorStateResult("登录失败", null);
        }
        Merchant merchant = merchantService.findMerchantByName(key);
        if (merchant == null) {
            return JsonResult.buildErrorStateResult("无效的商户", null);
        }
        LoginProperties loginProperties = new LoginProperties();
        loginProperties.setMerchantName(merchant.getName());
        loginProperties.setChannelId(channelId);
        loginProperties.setCreatedFrom(registerFrom);
        loginProperties.setAppChannel(appChannel);
        SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUser(new UserRet(user));
        loginInfo.setToken(sessionStruct.getSid());
        LoginInfo.LoginContext context = new LoginInfo.LoginContext();
        context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
        context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
        context.setAppChannel(appChannel);
        loginInfo.setLoginContext(context);
        LOGGER.info("第三方用户获取信息登录成功 [AppController] loginSuper --> loginFrom:{}, phoneNo:{},appChannel:{},channelId:{}", registerFrom, phoneNo, appChannel, channelId);
    /*
     * 部分免密渠道登录统计，用户中心不需识别，由统计平台来过滤
     * 贷款导航(84660)；壹账通H5(159384)
     */
        user.setRegisteredFrom(registerFrom);
        UserStatistics statistics = new UserStatistics(user, null, 4, channelId);
        //增加登陆统计发送
        MqUtils.sendLoanVest(statistics);

        return JsonResult.buildSuccessResult("", loginInfo);
    }

    /**
     * 第三方用户免密登录
     * 发现新手机号不会执行注册
     *
     * @param phoneNo      - 手机号
     * @param registerFrom - 注册渠道
     * @param channelId    -
     * @param appChannel   -
     * @param request
     * @return Token和phoneNo
     */
    @LogHttpCaller
    @IpValidator
    @RequestMapping("/login2")
    public JsonResult login2(
            String phoneNo,
            @RequestParam(required = false, defaultValue = "1") Long registerFrom,
            @RequestParam(required = false, defaultValue = "1") Long channelId,
            @RequestParam(required = false, defaultValue = "") String appChannel,
            HttpServletRequest request) {
        if (!ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
        }
        LOGGER.info("第三方用户登录 [AppController] login2 --> loginFrom:{},channelId:{}, requestIp:{}", registerFrom, channelId, IPUtil.getRemoteIP(request));
        User user = userService.findByPhoneInDb(phoneNo);
        if (user == null) {
            return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
        }
        if (!user.getEnable()) {
            return JsonResult.buildErrorStateResult("登录失败", null);
        }
        LoginProperties loginProperties = new LoginProperties();
        loginProperties.setChannelId(channelId);
        loginProperties.setCreatedFrom(registerFrom);
        loginProperties.setAppChannel(appChannel);
        SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);
        AuthBean bean = new AuthBean();
        bean.setToken(sessionStruct.getSid());
        bean.setPhoneNo(phoneNo);
        LOGGER.info("第三方用户登录成功 [AppController] login2 --> loginFrom:{}, phoneNo:{},appChannel:{}", registerFrom, phoneNo, appChannel);
        return new JsonResult(bean);
    }

}
