package cn.quantgroup.xyqb.config.sentry;

import cn.quantgroup.xyqb.exception.*;
import io.sentry.Sentry;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import org.slf4j.MDC;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * {@link HandlerExceptionResolver} implementation that will record any exception that a
 * Spring {@link org.springframework.web.servlet.mvc.Controller} throws to Sentry. It then
 * returns null, which will let the other (default or custom) exception resolvers handle
 * the actual error.
 */
public class CustomSentryExceptionResolver implements HandlerExceptionResolver, Ordered {

    @Override
    public ModelAndView resolveException(HttpServletRequest request,
                                         HttpServletResponse response,
                                         Object handler,
                                         Exception ex) {
        // TODO: 2020/2/4 临时测试，后期修改成通用。
        if (ex instanceof SilentBizException || ex instanceof VerificationCodeErrorException || ex instanceof DataException || ex instanceof UserRegisterLoginException
        || ex instanceof AppletException || ex instanceof AccessForbiddenException || ex instanceof PasswordErrorLimitException || ex instanceof BadCredentialsException
        || ex instanceof MethodArgumentNotValidException) {
            return null;
        }

        EventBuilder eventBuilder = new EventBuilder()
            .withSentryInterface(new ExceptionInterface(ex))
            .withMessage(ex.getMessage())
            .withTag("trace-id", MDC.get("X-B3-TraceId"))
            .withTag("span-id",MDC.get("X-B3-SpanId"));
        Sentry.capture(eventBuilder.build());

        // null = run other HandlerExceptionResolvers to actually handle the exception
        return null;
    }

    @Override
    public int getOrder() {
        // ensure this resolver runs first so that all exceptions are reported
        return Integer.MIN_VALUE;
    }
}