package cn.quantgroup.xyqb.controller.modifyphoneno;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.AuditReq;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.ModifyPhoneNoQueryReq;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step1Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step2Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.resp.ProgressResp;
import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IModifyPhoneNoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 * 用户手机号修改相关api
 * <p>
 * Date: 2019/11/4
 * Time: 上午11:23
 *
 * @author: yangrui
 */
@Api(tags = "用户手机号修改相关api")
@RestController
@RequestMapping("/v1/user/modify/phone_no")
public class ModifyPhoneNoController implements IBaseController {

    @Resource
    private IModifyPhoneNoService modifyPhoneNoService;

    @ApiOperation("app - 查询用户手机号修改进度")
    @GetMapping("/progress")
    public JsonResult<ProgressResp> progress() {
        User user = getCurrentUserFromRedis();
        if (user == null) {
            return JsonResult.buildErrorStateResult("系统错误", null);
        }
        return JsonResult.buildSuccessResultGeneric(modifyPhoneNoService.progress(user.getId()));
    }


    /**
     * step_1
     *
     * @param step1Req
     * @return
     */
    @ApiOperation("app - 申请修改手机号Step_1")
    @PostMapping("/step_1")
    public JsonResult step1(@Valid @RequestBody Step1Req step1Req) {
        User user = getCurrentUserFromRedis();
        if (user == null) {
            return JsonResult.buildErrorStateResult("系统错误", null);
        }
        return JsonResult.buildSuccessResultGeneric(modifyPhoneNoService.saveStep1(user.getId(), step1Req));
    }

    /**
     * step_2
     *
     * @param step2Req
     * @return
     */
    @ApiOperation("app - 申请修改手机号Step_2")
    @PostMapping("/step_2")
    public JsonResult step2(@Valid @RequestBody Step2Req step2Req) {
        modifyPhoneNoService.saveStep2(step2Req);
        return JsonResult.buildSuccessResult();
    }

    /*------------------------------------------------------------------------------------------------------------*/

    /**
     * 后台客服处理功能 - 查询列表
     */
    @ApiOperation("后台客服处理功能 - 查询列表")
    @GetMapping
    public JsonResult<?> list(@Valid ModifyPhoneNoQueryReq modifyPhoneNoQueryReq) {
        Page<ModifyPhoneNo> list = modifyPhoneNoService.list(modifyPhoneNoQueryReq);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        String s;
        try {
            s = objectMapper.writeValueAsString(list);
            Object o = objectMapper.readValue(s, Object.class);
            return JsonResult.buildSuccessResultGeneric(o);
        } catch (Exception ignored) {
        }
        return JsonResult.buildErrorStateResult("数据错误",null);
    }

    /**
     * 后台客服处理功能 - 人工审核
     */
    @ApiOperation("后台客服处理功能 - 人工审核")
    @PostMapping("/audit")
    public JsonResult audit(@Valid @RequestBody AuditReq auditReq) {
        modifyPhoneNoService.audit(auditReq);
        return JsonResult.buildSuccessResult();
    }

    /**
     * 后台客服处理功能 - 反馈跟进
     */
    @ApiOperation("后台客服处理功能 - 反馈跟进")
    @PostMapping("/{id}/feedback")
    public JsonResult feedback(@PathVariable Long id) {
        modifyPhoneNoService.feedback(id);
        return JsonResult.buildSuccessResult();
    }

    /*------------------------------------------------------------------------------------------------------------*/
}
