package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.req.v2.BehaviorRefreshReq;
import cn.quantgroup.xyqb.controller.req.v2.BehaviorReq;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import cn.quantgroup.xyqb.model.BehaviorCodeBean;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.imageio.ImageIO;
import javax.xml.bind.ValidationException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 公司自有验证码模式
 */
@Service
@Slf4j
public class QuantGroupBehaviorStrategy implements BehaviorStrategy {
    @Autowired
    @Qualifier("customCaptchaService")
    private AbstractManageableImageCaptchaService imageCaptchaService;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private IQuantgroupCaptchaService quantgroupCaptchaService;

    @Override
    public Integer getType() {
        return 2;
    }

    @Override
    public boolean validate(ValidateBehavior validateBehavior) {
        boolean result = quantgroupCaptchaService.validQuantgroupCaptcha(validateBehavior.getData().get(Constants.X_BEHAVIOR_ID), validateBehavior.getData().get(Constants.X_BEHAVIOR_IMAGEVALUE));
        if (result) {
            return true;
        } else {
            throw new VerificationCodeErrorException(BizExceptionEnum.FAIL_VERIFY_CODE);
        }
    }


    @Override
    public BehaviorCodeBean generate(BehaviorReq behaviorReq) {
        BehaviorCodeBean behaviorCodeBean = new BehaviorCodeBean();
        Map<String, String> challenge = quantgroupCaptchaService.fetchQuantgroupCaptcha(Locale.CHINA);
        if (challenge == null) {
            throw new VerificationCodeErrorException(BizExceptionEnum.FAIL_GENERATE_IMAGE);
        }
        behaviorCodeBean.setQtCode(BehaviorCodeBean.QtCode.builder().imageData(challenge.get("image")).build());
        behaviorCodeBean.setId(challenge.get("imageId"));
        return behaviorCodeBean;
    }

    @Override
    public BehaviorCodeBean refresh(BehaviorRefreshReq behaviorRefreshReq) {
        BufferedImage challenge = imageCaptchaService.getImageChallengeForID(Constants.IMAGE_CAPTCHA_KEY + behaviorRefreshReq.getId(), Locale.CHINA);
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(challenge, UserConstant.IMAGE_FORMAT_PNG, jpegOutputStream);
        } catch (IOException e) {
            throw new BizException(BizExceptionEnum.FAIL_GENERATE_IMAGE);
        }
        String imageBase64 = Base64.encodeBase64String(jpegOutputStream.toByteArray());
        BehaviorCodeBean behaviorCodeBean = new BehaviorCodeBean();
        behaviorCodeBean.setId(behaviorRefreshReq.getId());
        behaviorCodeBean.setType(2);
        behaviorCodeBean.setQtCode(BehaviorCodeBean.QtCode.builder().imageData(String.format(UserConstant.IMG_BASE64_PATTREN, imageBase64)).build());
        redisTemplate.opsForValue().set(Constants.IMAGE_CAPTCHA_REDIS_CACHE_KEY.concat(behaviorRefreshReq.getId()), "1", Constants.IMAGE_CAPTCHA_REDIS_CACHE_TIME_OUT, TimeUnit.MINUTES);
        return behaviorCodeBean;
    }
}
