package cn.quantgroup.xyqb.config;

import cn.quantgroup.xyqb.util.RequestBodyUtils;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Describe:
 * @Created by tangfeng 2023/7/25 07:05
 */
public class CustomHeaderRequestWrapper extends HttpServletRequestWrapper {
    private Map<String, String> headers = new HashMap<>();
    private String body;
    private String requestParam;
    public String getBody() {
        return body;
    }

    public String getRequestParam() {
        return requestParam;
    }

    public CustomHeaderRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
        //读取输入流的内容转换为String类型IOUtils必须引入org.apache.dubbo.common.utils.IOUtils;包
        String body = RequestBodyUtils.read(reader);
        this.body = body;
        this.requestParam = request.getQueryString();
    }

    /**
     * 增加 http header
     * @param name
     * @param value
     */
    public void addHeader(String name, String value) {
        headers.put(name, value);
    }

    @Override
    public String getHeader(String name) {
        String value = super.getHeader(name);

        //自定义优先
        if (headers.containsKey(name)) {
            value = headers.get(name);
        }

        return value;
    }

    /**
     * get the Header names
     */
    @Override
    public Enumeration<String> getHeaderNames() {
        List<String> names = Collections.list(super.getHeaderNames());
        for (String name : headers.keySet()) {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {

        List<String> values = Collections.list(super.getHeaders(name));

        if (headers.containsKey(name)) {

            values = Arrays.asList(headers.get(name));
        }

        return Collections.enumeration(values);
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }
    @Override
    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayIns = new ByteArrayInputStream(body.getBytes());
        ServletInputStream servletIns = new ServletInputStream() {
            @Override
            public boolean isFinished() {
                return false;
            }
            @Override
            public boolean isReady() {
                return false;
            }
            @Override
            public void setReadListener(ReadListener readListener) {
            }
            @Override
            public int read() throws IOException {
                return byteArrayIns.read();
            }
        };
        return  servletIns;
    }
}
