package cn.quantgroup.xyqb.security;

import cn.quantgroup.xyqb.urora.UroraAuthenticationToken;
import org.apache.commons.codec.binary.Base64;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * Created by Administrator on 2021/6/25 0025.
 */
@Aspect
@Component
public class AuthorizationAspect extends HttpAspect {

    private static final Logger logger = LoggerFactory.getLogger(AuthorizationAspect.class);
    @Pointcut("@annotation(cn.quantgroup.xyqb.security.AuthorizationPoint)")
    private void pointCut() {
    }

    @Around("pointCut()")
    private Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        AssentHeader header = getAssentHeader();
        AuthenticationManager manager = AuthenticationFactory.getManager(header.getAuthType());
        Authentication authenticate = manager.authenticate(getCredentials(header.getAuthMessage()));
        if(!authenticate.isAuthenticated()){
            throw new BadCredentialsException("not authorized");
        }
        AuthorityManager.authentication(authenticate);
        try {
            Object object = joinPoint.proceed();
            return object;
        }finally {
            AuthorityManager.release();
        }
    }

    public Authentication getCredentials(String credentials) throws AuthenticationException {

        String auth = ObjectUtils.getDisplayString(credentials);
        if (StringUtils.isEmpty(credentials)) {
            throw new BadCredentialsException("Authorization credentials does not look like urora. " + credentials);
        }

        auth = new String(Base64.decodeBase64(auth));
        String[] strings = auth.split(":");
        if (strings.length != 2) {
            throw new BadCredentialsException("Authorization credentials does not look like urora. " + auth);
        }
        return new UroraAuthenticationToken(strings[0], strings[1]);
    }
}
